package com.ejie.aa17a.control;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa17a.model.Aa17aAviso;
import com.ejie.aa17a.service.iface.Aa17aAvisoService;
import com.ejie.aa17a.utilidades.Aa17aConstantes;

/**
 * Aa17aAvisoController generated by UDA, 18-dic-2013 15:36:30.
 * 
 * @author UDA
 */

@RequestMapping(value = "/avisos")
public class Aa17aAvisoController {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aAvisoController.class);

	private Aa17aAvisoService aa17aAvisoService;

	/**
	 * Method 'getAll'.
	 * 
	 * @return List<Aa17aAviso>
	 */
	@RequestMapping(value = "generales", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aAviso> getAvisosGenerales() {
		Aa17aAvisoController.logger.info("[GET - find_ALL] : Obtener Aa17aAviso por filtro");

		Aa17aAviso filterAa17aAviso = new Aa17aAviso();
		filterAa17aAviso.setEstado(Aa17aConstantes.ESTADO_ACTIVO);//busco solo los que estén activos
		return this.aa17aAvisoService.findAll(filterAa17aAviso);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List
	 */
	@RequestMapping(value = "estacion/{idEstacion}", method = RequestMethod.GET)
	public @ResponseBody
	List<Aa17aAviso> getAvisosEstacion(@PathVariable Long idEstacion) {
		Aa17aAvisoController.logger.info("[GET - find_ALL] : Obtener Aa17aAviso por filtro");

		Aa17aAviso filterAa17aAviso = new Aa17aAviso();
		filterAa17aAviso.setEstado(Aa17aConstantes.ESTADO_ACTIVO);//busco solo los que estén activos
		filterAa17aAviso.setIdEstacion(idEstacion);
		return this.aa17aAvisoService.findAll(filterAa17aAviso);
	}

	/**
	 * Method 'setAa17aAvisoService'.
	 * 
	 * @param aa17aAvisoService
	 *            Aa17aAvisoService
	 * @return
	 */
	public void setAa17aAvisoService(Aa17aAvisoService aa17aAvisoService) {
		this.aa17aAvisoService = aa17aAvisoService;
	}
}
